select
 ' ' as "Regio Gerar"
 ,' ' as "Ano Gerar"
 ,' ' as "Tcnico"
 , mun.uf as "Estado"
 , mun.municipio as "Municpio"
 , faz.nome as "Fazenda"
 , se.nome as "Retiro"
 , faz.area as "Tamanho da Fazenda"
 , ' ' as "Ms do Incio da EM"
 , prog.nome as "Lote"
 , an.numero as "Nmero da matriz"
 , (select grausangue from sp_calculagrausangue(ia.cdanimal)) as "Raa da matriz"
 , (case when (an.cdcategoriainicial  = 7 and ((select count(*) from reproducao re where re.cdanimal = ia.cdanimal and re.data < ia.data and re.cdtiporeproducao = 7) + coalesce(an.numpartoentrada, 0)) = 0) then ''
          when iacat.cdcategoria = 3 then '3'
          when ((select count(*) from reproducao re where re.cdanimal = ia.cdanimal and re.data < ia.data and re.cdtiporeproducao = 7) + coalesce(an.numpartoentrada, 0)) = 0 then '0'
          when ((select count(*) from reproducao re where re.cdanimal = ia.cdanimal and re.data < ia.data and re.cdtiporeproducao = 7) + coalesce(an.numpartoentrada, 0)) = 1 then '1' 
          when ((select count(*) from reproducao re where re.cdanimal = ia.cdanimal and re.data < ia.data and re.cdtiporeproducao = 7) + coalesce(an.numpartoentrada, 0)) = 2 then 'S' 
          when ((select count(*) from reproducao re where re.cdanimal = ia.cdanimal and re.data < ia.data and re.cdtiporeproducao = 7) + coalesce(an.numpartoentrada, 0)) > 1 then '2' 
          else null end)
          as "Ordem da Matriz"
, ' ' as "Raa do Bezerro"
, ' ' as "Sexo do Bezerro"
,  ((ia.data - an.dtnascimento) / 30.5) as "Idade em meses"
, ' ' as "Peso da Novilha no Incio da EM"
, ' ' as "Induo de Puberdade"
, ' ' as "Mtodo de Induo de Puberdade"
, ultpar.data as "Data do ltimo Parto"
, (cast((select count(*) from reproducao re where re.cdanimal = an.cdanimal and re.cdtiporeproducao = 1 and re.data < ia.data and re.data > coalesce(ultpar.data, '1900-01-01')) as integer) + 1) as "Ordem da IA"
, ' ' as "Incio da Ressinc."
, (select first 1 re.valor from medida re where re.cdanimal = ia.cdanimal and re.cdtipomedida = 2 and re.dtmedida >= (ia.data - 15)
        and re.dtmedida <= (ia.data + 15) order by re.dtmedida desc) as "ECC Inicial"
, ' ' as "Suplementao"
, ' ' as "Momento Suplementao para Novilhas"
, ' ' as "Momento Suplementao para Vacas"
, ' ' as "Mineral"
, ' ' as "Lutalyse"
, ' ' as "Estmulo Ovulatrio"
, ' ' as "Estmulo Final"
, ' ' as "Dose de Novormon"
, (case when ia.cdprogramacaoiatf is not null then (prog.dtretirada - prog.dtimplante) when ia.cdprogramacaoiatf is null then null else null end) as "Dia da Retirada do Dispositivo"
, ' ' as "GnRH no Momento da IATF"
, ' ' as "MGA Ps-IATF"
, (case when
           ((select count(*) from aplicacaoproduto re join produto pre on pre.cdproduto = re.cdproduto where re.cdanimal = ia.cdanimal and
                   re.dtaplicacaoproduto < ia.data and re.dtaplicacaoproduto >= (ia.data - (12*30.5)) and
                   upper(pre.nome) like '%CATTLE%MASTER%') > 0)
       then '1' else '0' end) as "Cattle Master"
, (case when (upper(impl.nome) like '%CIDR%') THEN 'C'
          when (upper(impl.nome) like '%DIB%MONO%') THEN 'DM'
          when (upper(impl.nome) like '%DIB%') and (upper(impl.nome) not like '%MONO%') THEN 'D'
          else coalesce(impl.nome, paimp.nome) end) as "Dispositivo"
, coalesce(protimp.uso, ia.usocidr) as "No Usos do Dispositivo"
, ia.hora as "Manejo"
, ia.data as "Data IA/IATF"
, (case ia.cio when 1 then '1' when 2 then '0' when 0 then '0' else null end) as "Cio da Retirada at a IATF"
, ' ' as "Temperamento no dia da IATF"
, coalesce(rep.nome, rep.nomecompleto, rep.numero) as "Nome do Touro"
, (select grausangue from sp_calculagrausangue(rep.cdanimal)) as "Raa do Touro"
, cs.descricao as "Central de Smen"
, part.numero as "Partida do Smen"
, pes.nome as "Inseminador" 
, ' ' as "ECC no DG da IATF"
, (case when (exists (select * from reproducao re where re.cdanimal = ia.cdanimal and re.data > ia.data and re.data <= (ia.data + 35)
                            and re.cdtiporeproducao in (1,2,3))) then '0'
          when ((cat30.cdcategoria = 1) and (prox.diagnostico = 'P')) then '1'
          when (cat30.cdcategoria = 3) then '1'
          when (cat30.cdcategoria = 4) then '0'
          when ((cat30.cdcategoria = 1) and ((prox.diagnostico is null) or (prox.diagnostico <> 'P'))) then '0'
          else null end) as "Diag. IATF"
, ' ' as "CL no DG da IATF"
, (case catfim.cdcategoria
        when 1 then '0'
        when 2 then '0'
        when 3 then '1'
        when 4 then '0'
        else null end) as "Situao Final"
, ' ' as "ECC no DG Final da EM"
, dgfim.data as "Data Diag. Final"
, ' ' as "Peso do Bezerro no Dia do Diag. Final"
from
  fazenda faz
  join animal an on 1 = 1
  join reproducao ia on ia.cdanimal = an.cdanimal
  left join reproducao ultpar on ultpar.cdreproducao =
    (select first 1 re.cdreproducao from reproducao re where re.cdanimal = ia.cdanimal and re.cdtiporeproducao = 7 and re.data < ia.data
        order by re.data desc)
  left join reproducao iaant on iaant.cdreproducao =
    (select first 1 re.cdreproducao from reproducao re where re.cdanimal = ia.cdanimal and re.cdtiporeproducao in (1,2,3) and re.data >
    coalesce(ultpar.data, '1900-01-01') and re.data < ia.data order by re.data desc)
  left join protocoloiatf prot on prot.cdprotocoloiatf = ia.cdprotocoloiatf
  left join protocoloiatf prottotal on prottotal.cdprotocoloiatf = ia.cdprotocoloiatf
  left join protocoloiatfprincipioativo protpa on protpa.cdprotocoloiatfprincipioativo =
    (select first 1 re.cdprotocoloiatfprincipioativo from protocoloiatfprincipioativo re join principioativo repa on repa.cdprincipioativo
        = re.cdprincipioativo and upper(repa.nome) = 'PROGESTERONA' where re.cdprotocoloiatf = prot.cdprotocoloiatf order by re.uso asc)
  left join animal rep on rep.cdanimal = ia.cdreprodutor
  left join pessoa pes on pes.cdpessoa = ia.cdpessoa
  left join categoria cat on cat.cdcategoria = an.cdcategoria
  left join categoria cat30 on cat30.cdcategoria =
    (select creprodutiva from sp_categoriaanimal((ia.data + 35), 'cdanimal = ' || ia.cdanimal))
  left join categoria cat60 on cat60.cdcategoria =
    (select creprodutiva from sp_categoriaanimal((ia.data + 60), 'cdanimal = ' || ia.cdanimal))
  left join categoria iacat on iacat.cdcategoria =
    (select cprodutiva from sp_categoriaanimal(ia.data, 'cdanimal = ' || ia.cdanimal))
  left join reproducao prox on prox.cdreproducao =
    (select first 1 re.cdreproducao from reproducao re where re.cdanimal = ia.cdanimal and re.data > ia.data and
        ((re.cio in (1,2)) or (re.diagnostico is not null) or (re.cdtiporeproducao in (1,2,3,7))) order by re.data asc)
  left join municipio mun on faz.cdmunicipio = mun.cdmunicipio
  left join analiseleite anp on anp.cdanaliseleite =
    (select first 1 re.cdanaliseleite from analiseleite re where re.cdanimal = an.cdanimal and re.ccs is not null and re.dtanaliseleite > ultpar.data
        and re.dtanaliseleite < (ultpar.data + 30) order by re.dtanaliseleite asc)
  left join loteproduto part on ia.cdloteproduto = part.cdloteproduto
  left join protocoloiatfprincipioativo protimp on protimp.cdprotocoloiatfprincipioativo = 
  (select first 1 re.cdprotocoloiatfprincipioativo from protocoloiatfprincipioativo re where re.cdprotocoloiatf = prot.cdprotocoloiatf and re.dia = '0' and re.cdprincipioativo in (select re1.cdprincipioativo from principioativo re1 where upper(nome) like '%PROGESTERONA%'))
  left join protocoloiatfprincipioativo d7 on d7.cdprotocoloiatfprincipioativo = 
  (select first 1 re.cdprotocoloiatfprincipioativo from protocoloiatfprincipioativo re where re.cdprotocoloiatf = prot.cdprotocoloiatf and re.dia = '7')
  left join produto impl on impl.cdproduto = protimp.cdproduto
  left join principioativo paimp on paimp.cdprincipioativo = protimp.cdprincipioativo
  left join programacaoiatf prog on prog.cdprogramacaoiatf = ia.cdprogramacaoiatf
  left join principioativo pd7 on pd7.cdprincipioativo = d7.cdprincipioativo
  left join setor se on se.cdsetor =
      (select setor from sp_setoranimal(ia.cdanimal, ia.data))
  left join centralsemen cs on cs.cdcentralsemen = rep.cdcentralsemen
  left join reproducao dgfim on dgfim.cdreproducao = 
     (select first 1 re.cdreproducao from reproducao re where re.data > ia.data and re.cdtiporeproducao = 4 and re.data < current_date and re.cdanimal = ia.cdanimal order by re.data desc)
  left join categoria catfim on catfim.cdcategoria =
        (select creprodutiva from sp_categoriaanimal(current_date, ' cdanimal = ' || ia.cdanimal))
where
ia.cdtiporeproducao = 1
--- INFORME, AQUI, O PERODO DA ESTAO DE MONTA. MANTENHA AS ASPAS SIMPLES E O FORMATO AAAA-MM-DD.
and ia.data between '1900-01-01' and '2030-01-01'
---