select
		nt.cdnota,
        nt.tiponota,
        (case when (nti.estocavel=1) then 'Estoque' else 'Direta' end) as Origem ,
		nti.saidaimediata,
		nt.numdocumento as Num_Nota,
        nt.dtemissao,
		nt.dtentradasaida,
        Extract (Month from nt.dtentradasaida) as Mes_Emis,
        Extract (Year from nt.dtentradasaida) as Ano_Emis,
        ps.nome as fornecedor,
        cast(nt.valor as Numeric (15,2)) as Valor_Nota,
        nt.acrescimodesconto,
		pr.nome as produto,
        nti.qtde,
        nti.vrtotal as Valor_Item,
        (case when (nia.percentual is null) then nti.vrtotal else ((nti.vrtotal * nia.percentual) / 100) end) as valor_item_CC,
        cc.numero ||' - '|| cc.descricao as Centro_Custo,
        pt.descricao as Patrimonio,
        cg1.numero ||' - '|| cg1.descricao as conta_gerencial1,
        cg2.numero ||' - '|| cg2.descricao as conta_gerencial2,
        cg3.numero ||' - '|| cg3.descricao as conta_gerencial3,
        cg.numero ||' - '|| cg.descricao as conta_gerencial4,
        nia.percentual,
        mov.dtvencimento,
        Extract (Month from mov.dtvencimento) as Mes_Vcto,
        Extract (Year from mov.dtvencimento) as Ano_Vcto,
        (case when(mov.dtvencimento < current_date and mov.dtpagamento is null) then 'Vencido' else 'No Vencido' end) as Vencido,
        mov.valor as Valor_Parcela,
        mov.dtpagamento,
        Extract (Month from mov.dtpagamento) as Mes_Pgto,
        Extract (Year from mov.dtpagamento) as Ano_Pgto,
        (case when(mov.dtpagamento is null) then 'No Pago' else 'Pago' end) as Pago,
        mov.vrpago as Valor_Pago,
        mov.dtcompensacao,
        Extract (Month from mov.dtcompensacao) as Mes_Comp,
        Extract (Year from mov.dtcompensacao) as Ano_Comp,
        (case when(mov.dtcompensacao is null) then 'No compensado' else 'Compensado' end) as Compensado,
        mov.numdocumento as Doc_Pgto,
        co.descricao as conta_corrente,
        mov.cdtipopagamentorecebimento as Tipo_Pgto_Rcbto,
        (cast((case
		when nt.valor = 0 then 0
		else ((CASE
		       when (nia.percentual is null) then nti.vrtotal
		       else ((nti.vrtotal * nia.percentual) / 100) end)/nt.valor) end) as Numeric(15,4)) * (case 
					    	         																when mov.vrpago is null 
					    	         																then mov.valor
					    	         																else mov.vrpago end) * (case 
					    	         																						when nt.tiponota='E' 
					    	         																						then -1 
					    	         																						else 1 end)) as Valor_Realizado
        from
        nota nt
        join notaitem nti on nti.cdnota=nt.cdnota
        left join pessoa ps on nt.cdpessoa=ps.cdpessoa
        join produto pr on nti.cdproduto=pr.cdproduto
        left join notaitemapro nia on nti.cdnotaitem=nia.cdnotaitem
        left join centrocusto cc on cc.cdcentrocusto=nia.cdcentrocusto
        join contagerencial cg on nti.cdcontagerencial=cg.cdcontagerencial
        left join contagerencial cg1 on substring(cg.numero from 1 for 1)=cg1.numero
        left join contagerencial cg2 on substring(cg.numero from 1 for 4)=cg2.numero
        left join contagerencial cg3 on substring(cg.numero from 1 for 7)=cg3.numero
        join movimento mov on mov.cdnota=nt.cdnota
        left join contacorrente co on co.cdcontacorrente = mov.cdcontacorrente
        left join patrimonio pt on pt.cdpatrimonio=nti.cdpatrimonio
        where nt.cdnotavinculada is NULL