select
     an.numero
     , ap1.datainicio as Data_inicio
     , ap1.observacao as obs_classificacao
     , (case
            when (ap1.tipo = 1) then 'DOADORA'
            when (AP1.tipo = 2) then 'RECEPTORA'
            when (AP1.tipo = 3) then 'DESCARTE'
         else null end) as tipo_classificacao
from
    animal an
    left join animalperiodo ap1 on ap1.cdanimalperiodo =
        (select first 1 re.cdanimalperiodo from animalperiodo re where re.cdanimal = an.cdanimal
            order by re.datainicio desc)
where
    an.dtbaixa is null
    and an.cdcategoria in (6,7)
    and an.animalrebanho = 1
    and an.cdanimal in (select cdanimal from animalperiodo)